/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于合并模组
 *
 * 修改:
 *      类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.04.27
 *      内容 : 所有代码
 *************************************************************************************************/
/* exported  mc_jungle_mod_cnt */
/* exported  mc_jungle_mod_repeat */


/* global mc_sdk_param */


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:检验当前时钟模式下的模组是否超过指定时钟数
 *
 * 参数:
 *    @param {Promise<Array>} arr_data   当前界面设置的模组数据
 *    @param {Promise<Number>} ui_add_cnt   添加的模组数量 ( 在切换模式时此值为空 )

 * 返回：
 *    @param {Promise<boolean>} b_less false->超出 true ->未超出

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.04.27
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_jungle_mod_cnt(arr_data, ui_add_cnt) {
    var b_less = true;
    var ui_len = arr_data.length;
    var ui_curr = 0;

    for (var id = 0; id < ui_len; id++) {
        if (!arr_data[id].id_mod_cnt) {
            ui_curr = id - 1;
            break;
        }
    }

    // 添加加进来的数量
    if (ui_add_cnt) {
        ui_curr += ui_add_cnt;
    }

    if (11 <= ui_curr) {
        b_less = false;
    }

    return b_less;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:  检验添加的模组是否重复
 *
 * 参数:
 *    @param {Promise<Array>} arr_mod_add   添加的模组
 *    @param {Promise<Number>} arr_mod_curr  界面存储的模组

 * 返回：
 *    @param {Promise<boolean>} b_exist false->存在相同 true ->不同

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.04.28
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_jungle_mod_repeat(arr_mod_add, arr_mod_curr) {
    var b_exist = true;

    for (var id_select_mod = 0; id_select_mod < arr_mod_add.length; id_select_mod++) {
        var arr_mod_sequence = arr_mod_add[id_select_mod][0].classList;
        var str_mod_sequence;

        for (var idx_mod_seq = 0; idx_mod_seq < arr_mod_sequence.length; idx_mod_seq++) {
            if (-1 !== arr_mod_sequence[idx_mod_seq].indexOf("set_merge_mod")) {
                str_mod_sequence = arr_mod_sequence[idx_mod_seq];
            }
        }
        for (var idx_repeat_mod = 0; idx_repeat_mod < arr_mod_curr.length; idx_repeat_mod++) {
            if (arr_mod_curr[idx_repeat_mod].id_mod_cnt === str_mod_sequence) {
                b_exist = false;
            }
        }
    }

    return b_exist;
}
